#!/bin/bash

. /home/liferay/.bash_profile

echo "Installing Liferay Tomcat Bundle. Source: ${LIFERAY_TOMCAT_BUNDLE}"
echo "Install Location: ${BASE_DIRECTORY}"

if [ ! -f ${SOFTWARE_DIRECTORY}/${LIFERAY_TOMCAT_BUNDLE} ]; then
	# Download the file from the tools server.
	echo "Downloading file ${BASE_TOOLS_URL}/liferay/${LIFERAY_SP}/${LIFERAY_TOMCAT_BUNDLE}."
	wget -q --tries=20 --continue --retry-connrefused --waitretry=5 --read-timeout=20 ${BASE_TOOLS_URL}/liferay/${LIFERAY_SP}/${LIFERAY_TOMCAT_BUNDLE} -O ${SOFTWARE_DIRECTORY}/${LIFERAY_TOMCAT_BUNDLE}
	
	if [ $? -ne 0 ]; then
		echo "Error Downloading File: ${LIFERAY_TOMCAT_BUNDLE} from location ${BASE_TOOLS_URL}/liferay/${LIFERAY_SP}. Check network connectivity and file existence and then retry."
		exit $?
	fi
fi

unzip -q ${SOFTWARE_DIRECTORY}/${LIFERAY_TOMCAT_BUNDLE} -d ${BASE_DIRECTORY}

chown -R liferay:liferay ${LIFERAY_HOME}

echo "Updating Liferay Tomcat Server Configuration with Liferay Datasource jdbc/liferayShared."
sudo su - liferay -c "cp /vagrant/liferay/tomcat-server.xml ${LIFERAY_TOMCAT_HOME}/conf/server.xml"
sudo su - liferay -c "sed -i.bak "s/DB_INFO/${MHV_DB_INFO}/g" ${LIFERAY_TOMCAT_HOME}/conf/server.xml"
sudo su - liferay -c "sed -i.bak "s/DEVID/${MHV_DB_ID}/g" ${LIFERAY_TOMCAT_HOME}/conf/server.xml"

echo "Updating Liferay Tomcat Context with Liferay Datasource jdbc/liferay."
sudo su - liferay -c "cp /vagrant/liferay/tomcat-context.xml ${LIFERAY_TOMCAT_HOME}/conf/context.xml"

echo "Updating the Tomcat environment."
sudo su - liferay -c "cp /vagrant/liferay/tomcat-setenv.sh ${LIFERAY_TOMCAT_HOME}/bin/setenv.sh"

echo "Removing unecessary Liferay plugins from Tomcat deployments."
rm -rf ${LIFERAY_TOMCAT_HOME}/webapps/opensocial-portlet
rm -rf ${LIFERAY_TOMCAT_HOME}/webapps/sync-*

echo "Install the Oracle JDBC Driver in the Liferay Tomcat library extensions folder."
sudo su - liferay -c "cp ${SOFTWARE_DIRECTORY}/ojdbc6-11.1.0.7.0.jar $LIFERAY_TOMCAT_HOME/lib/ext"

echo "Installing license file for Liferay 6.2 EE."
sudo su - liferay -c "ln -s /deploy ${LIFERAY_HOME}/deploy"
sudo su - liferay -c "cp ${SOFTWARE_DIRECTORY}/license-portaldevelopment-developer-6.2ee.xml ${LIFERAY_HOME}/deploy/" 

echo "Installing Liferay Properties file."
sudo su - liferay -c "cp /vagrant/liferay/portal-ext.properties ${LIFERAY_HOME}/"
sudo su - liferay -c "cp /vagrant/liferay/portal-setup-wizard.properties ${LIFERAY_HOME}/"

echo "sudo su - liferay -c \"sed -i.bak 's/FOLDER/${LIFERAY_FOLDER}/g' ${LIFERAY_HOME}/portal-setup-wizard.properties\""
sudo su - liferay -c "sed -i.bak 's/FOLDER/${LIFERAY_FOLDER}/g' ${LIFERAY_HOME}/portal-setup-wizard.properties"

echo "Downloading the latest MHV-R content. (Please be patient. This is a large file and may take a while to complete depending on your connection speed.)"
wget -q --tries=20 --continue --retry-connrefused --waitretry=5 --read-timeout=20 ${BASE_TOOLS_URL}/mhv/SYST-content-latest.zip -O ${SOFTWARE_DIRECTORY}/SYST-content-latest.zip

if [ $? -ne 0 ]; then
	echo "Error Downloading File: SYST-content-latest.zip from location ${BASE_TOOLS_URL}/mhv. Check network connectivity and file existence and then retry."
	exit $?
fi

sudo su - liferay -c "unzip ${SOFTWARE_DIRECTORY}/SYST-content-latest.zip -d ${LIFERAY_HOME}/data/"

#echo "Installing common locally in ${TOMCAT_HOME}/lib."
#sudo su - liferay -c "curl -sSo ${LIFERAY_TOMACT_HOME}/lib/jsf-api-2.2.12.jar http://vapcpappmhvcm82.tmc.va.gov:8081/nexus/service/local/repositories/central/content/com/sun/faces/jsf-api/2.2.12/jsf-api-2.2.12.jar"
#sudo su - liferay -c "curl -sSo ${LIFERAY_TOMACT_HOME}/lib/jsf-impl-2.2.12.jar http://vapcpappmhvcm82.tmc.va.gov:8081/nexus/service/local/repositories/central/content/com/sun/faces/jsf-impl/2.2.12/jsf-impl-2.2.12.jar"
#sudo su - liferay -c "cp /installs/jsf-*-2.2*.jar ${LIFERAY_TOMCAT_HOME}/lib && chmod 644 ${LIFERAY_TOMCAT_HOME}/lib/jsf-*-2.2*.jar"

if [ ! -f ${SOFTWARE_DIRECTORY}/mhv-trust.jks ]; then
	# Download the file from the tools server.
	echo "Downloading file ${BASE_TOOLS_URL}/mhv/mhv-trust.jks."
	wget -q --tries=20 --continue --retry-connrefused --waitretry=5 --read-timeout=20 ${BASE_TOOLS_URL}/mhv/mhv-trust.jks -O ${SOFTWARE_DIRECTORY}/mhv-trust.jks
	
	if [ $? -ne 0 ]; then
		echo "Error Downloading File: mhv-trust.jks from location ${BASE_TOOLS_URL}/mhv. Check network connectivity and file existence and then retry."
		exit $?
	fi
fi

if [ ! -f ${SOFTWARE_DIRECTORY}/mhv_identity.jks ]; then
	# Download the file from the tools server.
	echo "Downloading file ${BASE_TOOLS_URL}/mhv/mhv_identity.jks."
	wget -q --tries=20 --continue --retry-connrefused --waitretry=5 --read-timeout=20 ${BASE_TOOLS_URL}/mhv/mhv_identity.jks -O ${SOFTWARE_DIRECTORY}/mhv_identity.jks
	
	if [ $? -ne 0 ]; then
		echo "Error Downloading File: mhv_identity.jks from location ${BASE_TOOLS_URL}/mhv. Check network connectivity and file existence and then retry."
		exit $?
	fi
fi

echo "Adding mhv-trust.jks trust store and mhv_identity.jks identity store to /opt/share/keystore/."
sudo mkdir -p /opt/share/keystore
sudo chown -R liferay:liferay /opt/share
sudo su - liferay -c "cp ${SOFTWARE_DIRECTORY}/mhv-trust.jks /opt/share/keystore/"
sudo su - liferay -c "cp ${SOFTWARE_DIRECTORY}/mhv_identity.jks /opt/share/keystore/"
